/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.gameevent.EuclideanGameEventDispatcher;
import net.minecraft.world.level.gameevent.GameEventDispatcher;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.SerializableTickContainer;
import net.minecraft.world.ticks.TickContainerAccess;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilityProviderImpl;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.timings.TimeTracker;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_18_R2.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class LevelChunk
extends ChunkAccess
implements ICapabilityProviderImpl<LevelChunk> {
    static final Logger f_62771_ = LogUtils.getLogger();
    private static final TickingBlockEntity f_156361_ = new TickingBlockEntity(){

        public void m_142224_() {
        }

        public boolean m_142220_() {
            return true;
        }

        public BlockPos m_142689_() {
            return BlockPos.f_121853_;
        }

        public String m_142280_() {
            return "<null>";
        }
    };
    private final Map<BlockPos, RebindableTickingBlockEntityWrapper> f_156362_ = Maps.newHashMap();
    public boolean f_62775_;
    private boolean f_196848_ = false;
    public final Level f_62776_;
    @Nullable
    private Supplier<ChunkHolder.FullChunkStatus> f_62790_;
    @Nullable
    private PostLoadProcessor f_62791_;
    private final Int2ObjectMap<GameEventDispatcher> f_156363_;
    private final LevelChunkTicks<Block> f_62784_;
    private final LevelChunkTicks<Fluid> f_187943_;
    public Chunk bukkitChunk;
    public boolean mustNotSave;
    public boolean needsDecoration;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    private final CapabilityProvider.AsField<LevelChunk> capProvider = new CapabilityProvider.AsField(LevelChunk.class, (ICapabilityProviderImpl)this);

    public Chunk getBukkitChunk() {
        return this.bukkitChunk;
    }

    public LevelChunk(Level p_187945_, ChunkPos p_187946_) {
        this(p_187945_, p_187946_, UpgradeData.f_63320_, (LevelChunkTicks<Block>)new LevelChunkTicks(), (LevelChunkTicks<Fluid>)new LevelChunkTicks(), 0L, null, null, null);
    }

    public LevelChunk(Level p_196854_, ChunkPos p_196855_, UpgradeData p_196856_, LevelChunkTicks<Block> p_196857_, LevelChunkTicks<Fluid> p_196858_, long p_196859_, @Nullable LevelChunkSection[] p_196860_, @Nullable PostLoadProcessor p_196861_, @Nullable BlendingData p_196862_) {
        super(p_196855_, p_196856_, (LevelHeightAccessor)p_196854_, p_196854_.m_5962_().m_175515_(Registry.f_122885_), p_196859_, p_196860_, p_196862_);
        this.f_62776_ = p_196854_;
        this.f_156363_ = new Int2ObjectOpenHashMap();
        for (Heightmap.Types heightmap$types : Heightmap.Types.values()) {
            if (!ChunkStatus.f_62326_.m_62500_().contains(heightmap$types)) continue;
            this.f_187608_.put(heightmap$types, new Heightmap((ChunkAccess)this, heightmap$types));
        }
        this.f_62791_ = p_196861_;
        this.f_62784_ = p_196857_;
        this.f_187943_ = p_196858_;
        this.capProvider.initInternal();
        if (p_196855_ != null) {
            this.bukkitChunk = new CraftChunk(this);
        }
    }

    public LevelChunk(ServerLevel p_196850_, ProtoChunk p_196851_, @Nullable PostLoadProcessor p_196852_) {
        this(p_196850_, p_196851_.m_7697_(), p_196851_.m_7387_(), p_196851_.m_188181_(), p_196851_.m_188182_(), p_196851_.m_6319_(), p_196851_.m_7103_(), p_196852_, p_196851_.m_183407_());
        for (BlockEntity blockentity : p_196851_.m_63292_().values()) {
            this.m_142169_(blockentity);
        }
        this.f_187609_.putAll(p_196851_.m_63294_());
        for (int i = 0; i < p_196851_.m_6720_().length; ++i) {
            this.f_187602_[i] = p_196851_.m_6720_()[i];
        }
        this.m_8040_(p_196851_.m_6633_());
        this.m_7946_(p_196851_.m_7049_());
        for (Map.Entry<Heightmap.Types, Heightmap> entry : p_196851_.m_6890_()) {
            if (!ChunkStatus.f_62326_.m_62500_().contains(entry.getKey())) continue;
            this.m_6511_(entry.getKey(), entry.getValue().m_64239_());
        }
        this.m_8094_(p_196851_.m_6332_());
        this.f_187603_ = true;
        this.needsDecoration = true;
        this.persistentDataContainer = p_196851_.persistentDataContainer;
    }

    @Override
    public TickContainerAccess<Block> m_183531_() {
        return this.f_62784_;
    }

    @Override
    public TickContainerAccess<Fluid> m_183526_() {
        return this.f_187943_;
    }

    @Override
    public ChunkAccess.TicksToSave m_183568_() {
        return new ChunkAccess.TicksToSave((SerializableTickContainer<Block>)this.f_62784_, (SerializableTickContainer<Fluid>)this.f_187943_);
    }

    @Override
    public GameEventDispatcher m_142336_(int p_156372_) {
        return (GameEventDispatcher)this.f_156363_.computeIfAbsent(p_156372_, p_156395_ -> new EuclideanGameEventDispatcher(this.f_62776_));
    }

    @Override
    public BlockState m_8055_(BlockPos p_62923_) {
        int i = p_62923_.m_123341_();
        int j = p_62923_.m_123342_();
        int k = p_62923_.m_123343_();
        if (this.f_62776_.m_46659_()) {
            BlockState blockstate = null;
            if (j == 60) {
                blockstate = Blocks.f_50375_.m_49966_();
            }
            if (j == 70) {
                blockstate = DebugLevelSource.m_64148_(i, k);
            }
            return blockstate == null ? Blocks.f_50016_.m_49966_() : blockstate;
        }
        try {
            LevelChunkSection levelchunksection;
            int l = this.m_151564_(j);
            if (l >= 0 && l < this.f_187612_.length && !(levelchunksection = this.f_187612_[l]).m_188008_()) {
                return levelchunksection.m_62982_(i & 0xF, j & 0xF, k & 0xF);
            }
            return Blocks.f_50016_.m_49966_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Getting block state");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being got");
            crashreportcategory.m_128165_("Location", (CrashReportDetail<String>)((CrashReportDetail)() -> CrashReportCategory.m_178942_(this, i, j, k)));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    public FluidState m_6425_(BlockPos p_62895_) {
        return this.m_62814_(p_62895_.m_123341_(), p_62895_.m_123342_(), p_62895_.m_123343_());
    }

    public FluidState m_62814_(int p_62815_, int p_62816_, int p_62817_) {
        try {
            LevelChunkSection levelchunksection;
            int i = this.m_151564_(p_62816_);
            if (i >= 0 && i < this.f_187612_.length && !(levelchunksection = this.f_187612_[i]).m_188008_()) {
                return levelchunksection.m_63007_(p_62815_ & 0xF, p_62816_ & 0xF, p_62817_ & 0xF);
            }
            return Fluids.f_76191_.m_76145_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_(throwable, "Getting fluid state");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being got");
            crashreportcategory.m_128165_("Location", (CrashReportDetail<String>)((CrashReportDetail)() -> CrashReportCategory.m_178942_(this, p_62815_, p_62816_, p_62817_)));
            throw new ReportedException(crashreport);
        }
    }

    @Override
    @Nullable
    public BlockState m_6978_(BlockPos p_62865_, BlockState p_62866_, boolean p_62867_) {
        return this.setBlockState(p_62865_, p_62866_, p_62867_, true);
    }

    public BlockState setBlockState(BlockPos p_62865_, BlockState p_62866_, boolean p_62867_, boolean doPlace) {
        int l;
        int k;
        int i = p_62865_.m_123342_();
        LevelChunkSection levelchunksection = this.m_183278_(this.m_151564_(i));
        boolean flag = levelchunksection.m_188008_();
        if (flag && p_62866_.m_60795_()) {
            return null;
        }
        int j = p_62865_.m_123341_() & 0xF;
        BlockState blockstate = levelchunksection.m_62986_(j, k = i & 0xF, l = p_62865_.m_123343_() & 0xF, p_62866_);
        if (blockstate == p_62866_) {
            return null;
        }
        Block block = p_62866_.m_60734_();
        ((Heightmap)this.f_187608_.get(Heightmap.Types.MOTION_BLOCKING)).m_64249_(j, i, l, p_62866_);
        ((Heightmap)this.f_187608_.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES)).m_64249_(j, i, l, p_62866_);
        ((Heightmap)this.f_187608_.get(Heightmap.Types.OCEAN_FLOOR)).m_64249_(j, i, l, p_62866_);
        ((Heightmap)this.f_187608_.get(Heightmap.Types.WORLD_SURFACE)).m_64249_(j, i, l, p_62866_);
        boolean flag1 = levelchunksection.m_188008_();
        if (flag != flag1) {
            this.f_62776_.m_7726_().m_7827_().m_75834_(p_62865_, flag1);
        }
        boolean flag2 = blockstate.m_155947_();
        if (!this.f_62776_.f_46443_) {
            blockstate.m_60753_(this.f_62776_, p_62865_, p_62866_, p_62867_);
        } else if (!(blockstate.m_60713_(block) && p_62866_.m_155947_() || !flag2)) {
            this.m_8114_(p_62865_);
        }
        if (!levelchunksection.m_62982_(j, k, l).m_60713_(block)) {
            return null;
        }
        if (!this.f_62776_.f_46443_ && doPlace && (!this.f_62776_.captureBlockSnapshots || block instanceof BaseEntityBlock)) {
            p_62866_.m_60696_(this.f_62776_, p_62865_, blockstate, p_62867_);
        }
        if (p_62866_.m_155947_()) {
            BlockEntity blockentity = this.m_5685_(p_62865_, EntityCreationType.CHECK);
            if (blockentity == null) {
                blockentity = ((EntityBlock)block).m_142194_(p_62865_, p_62866_);
                if (blockentity != null) {
                    this.m_142170_(blockentity);
                }
            } else {
                blockentity.m_155250_(p_62866_);
                this.m_156406_(blockentity);
            }
        }
        this.f_187603_ = true;
        return blockstate;
    }

    @Override
    @Deprecated
    public void m_6286_(Entity p_62826_) {
    }

    @Nullable
    private BlockEntity m_62934_(BlockPos p_62935_) {
        BlockState blockstate = this.m_8055_(p_62935_);
        return !blockstate.m_155947_() ? null : ((EntityBlock)blockstate.m_60734_()).m_142194_(p_62935_, blockstate);
    }

    @Override
    @Nullable
    public BlockEntity m_7702_(BlockPos p_62912_) {
        return this.m_5685_(p_62912_, EntityCreationType.CHECK);
    }

    @Nullable
    public BlockEntity m_5685_(BlockPos p_62868_, EntityCreationType p_62869_) {
        BlockEntity blockentity1;
        CompoundTag compoundtag;
        BlockEntity blockentity = this.f_62776_.capturedTileEntities.get(p_62868_);
        if (blockentity == null) {
            blockentity = (BlockEntity)((Object)this.f_187610_.get(p_62868_));
        }
        if (blockentity != null && blockentity.m_58901_()) {
            this.f_187610_.remove(p_62868_);
            blockentity = null;
        }
        if (blockentity == null && (compoundtag = (CompoundTag)this.f_187609_.remove(p_62868_)) != null && (blockentity1 = this.m_62870_(p_62868_, compoundtag)) != null) {
            return blockentity1;
        }
        if (blockentity == null && p_62869_ == EntityCreationType.IMMEDIATE && (blockentity = this.m_62934_(p_62868_)) != null) {
            this.m_142170_(blockentity);
        }
        return blockentity;
    }

    public void m_142170_(BlockEntity p_156391_) {
        this.m_142169_(p_156391_);
        if (this.m_156370_()) {
            this.m_156404_(p_156391_);
            this.m_156406_(p_156391_);
            p_156391_.onLoad();
        }
    }

    private boolean m_156370_() {
        return this.f_62775_ || this.f_62776_.m_5776_();
    }

    boolean m_156410_(BlockPos p_156411_) {
        if (!this.f_62776_.m_6857_().m_61937_(p_156411_)) {
            return false;
        }
        Level level = this.f_62776_;
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverlevel = (ServerLevel)level;
        return this.m_6708_().m_140114_(ChunkHolder.FullChunkStatus.TICKING) && serverlevel.m_143319_(ChunkPos.m_151388_((BlockPos)p_156411_));
    }

    @Override
    public void m_142169_(BlockEntity p_156374_) {
        BlockPos blockpos = p_156374_.m_58899_();
        if (this.m_8055_(blockpos).m_155947_()) {
            p_156374_.m_142339_(this.f_62776_);
            p_156374_.m_6339_();
            BlockEntity blockentity = this.f_187610_.put(blockpos.m_7949_(), p_156374_);
            if (blockentity != null && blockentity != p_156374_) {
                blockentity.m_7651_();
            }
        } else {
            System.out.println("Attempted to place a tile entity (" + p_156374_ + ") at " + p_156374_.m_58899_().m_123341_() + "," + p_156374_.m_58899_().m_123342_() + "," + p_156374_.m_58899_().m_123343_() + " (" + this.m_8055_(blockpos) + ") where there was no entity tile!");
            System.out.println("Chunk coordinates: " + this.f_187604_.f_45578_ * 16 + "," + this.f_187604_.f_45579_ * 16);
            new Exception().printStackTrace();
        }
    }

    @Override
    @Nullable
    public CompoundTag m_8051_(BlockPos p_62932_) {
        BlockEntity blockentity = this.m_7702_(p_62932_);
        if (blockentity != null && !blockentity.m_58901_()) {
            try {
                CompoundTag compoundtag1 = blockentity.m_187480_();
                compoundtag1.m_128379_("keepPacked", false);
                return compoundtag1;
            }
            catch (Exception e) {
                f_62771_.error("A BlockEntity type {} has thrown an exception trying to write state. It will not persist, Report this to the mod author", (Object)((Object)((Object)blockentity)).getClass().getName(), (Object)e);
                return null;
            }
        }
        CompoundTag compoundtag = (CompoundTag)this.f_187609_.get(p_62932_);
        if (compoundtag != null) {
            compoundtag = compoundtag.m_6426_();
            compoundtag.m_128379_("keepPacked", true);
        }
        return compoundtag;
    }

    @Override
    public void m_8114_(BlockPos p_62919_) {
        if (this.m_156370_()) {
            BlockEntity blockentity = (BlockEntity)((Object)this.f_187610_.remove(p_62919_));
            if (!this.f_187609_.isEmpty()) {
                this.f_187609_.remove(p_62919_);
            }
            if (blockentity != null) {
                this.m_156396_(blockentity);
                blockentity.m_7651_();
            }
        }
        this.m_156412_(p_62919_);
    }

    private <T extends BlockEntity> void m_156396_(T p_156397_) {
        GameEventListener gameeventlistener;
        Block block;
        if (!this.f_62776_.f_46443_ && (block = p_156397_.m_58900_().m_60734_()) instanceof EntityBlock && (gameeventlistener = ((EntityBlock)block).m_142226_(this.f_62776_, p_156397_)) != null) {
            int i = SectionPos.m_123171_((int)p_156397_.m_58899_().m_123342_());
            GameEventDispatcher gameeventdispatcher = this.m_142336_(i);
            gameeventdispatcher.m_142500_(gameeventlistener);
            if (gameeventdispatcher.m_142086_()) {
                this.f_156363_.remove(i);
            }
        }
    }

    private void m_156412_(BlockPos p_156413_) {
        RebindableTickingBlockEntityWrapper levelchunk$rebindabletickingblockentitywrapper = this.f_156362_.remove(p_156413_);
        if (levelchunk$rebindabletickingblockentitywrapper != null) {
            levelchunk$rebindabletickingblockentitywrapper.m_156449_(f_156361_);
        }
    }

    public void m_62952_() {
        if (this.f_62791_ != null) {
            this.f_62791_.m_196866_(this);
            this.f_62791_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        CraftServer server = this.f_62776_.getCraftServer();
        if (server != null) {
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent(this.bukkitChunk, this.needsDecoration));
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                ServerLevel level = (ServerLevel)this.f_62776_;
                random.setSeed(level.m_7328_());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.f_187604_.f_45578_ * xRand + (long)this.f_187604_.f_45579_ * zRand ^ level.m_7328_());
                CraftWorld world = level.getWorld();
                if (world != null) {
                    this.f_62776_.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((World)world, random, this.bukkitChunk);
                        }
                    }
                    finally {
                        this.f_62776_.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent(this.bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        CraftServer server = this.f_62776_.getCraftServer();
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent(this.bukkitChunk, this.m_6344_());
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
    }

    @Override
    public boolean m_6344_() {
        return super.m_6344_() && !this.mustNotSave;
    }

    public boolean m_6430_() {
        return false;
    }

    public void m_187971_(FriendlyByteBuf p_187972_, CompoundTag p_187973_, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> p_187974_) {
        this.m_187957_();
        for (LevelChunkSection levelChunkSection : this.f_187612_) {
            levelChunkSection.m_63004_(p_187972_);
        }
        for (LevelChunkSection levelChunkSection : Heightmap.Types.values()) {
            String s = levelChunkSection.m_64294_();
            if (!p_187973_.m_128425_(s, 12)) continue;
            this.m_6511_((Heightmap.Types)levelChunkSection, p_187973_.m_128467_(s));
        }
        p_187974_.accept((p_187968_, p_187969_, p_187970_) -> {
            BlockEntity blockentity = this.m_5685_(p_187968_, EntityCreationType.IMMEDIATE);
            if (blockentity != null && p_187970_ != null && blockentity.m_58903_() == p_187969_) {
                blockentity.handleUpdateTag(p_187970_);
            }
        });
    }

    public void m_62913_(boolean p_62914_) {
        this.f_62775_ = p_62914_;
    }

    public Level m_62953_() {
        return this.f_62776_;
    }

    public Map<BlockPos, BlockEntity> m_62954_() {
        return this.f_187610_;
    }

    @Override
    public Stream<BlockPos> m_6267_() {
        return StreamSupport.stream(BlockPos.m_121976_((int)this.f_187604_.m_45604_(), (int)this.m_141937_(), (int)this.f_187604_.m_45605_(), (int)this.f_187604_.m_45608_(), (int)(this.m_151558_() - 1), (int)this.f_187604_.m_45609_()).spliterator(), false).filter(p_187990_ -> this.m_8055_((BlockPos)p_187990_).getLightEmission((BlockGetter)((Object)this.m_62953_()), (BlockPos)p_187990_) != 0);
    }

    public void m_62812_() {
        ChunkPos chunkpos = this.m_7697_();
        for (int i = 0; i < this.f_187602_.length; ++i) {
            if (this.f_187602_[i] == null) continue;
            for (Short oshort : this.f_187602_[i]) {
                BlockPos blockpos = ProtoChunk.m_63227_(oshort, this.m_151568_(i), chunkpos);
                BlockState blockstate = this.m_8055_(blockpos);
                FluidState fluidstate = blockstate.m_60819_();
                if (!fluidstate.m_76178_()) {
                    fluidstate.m_76163_(this.f_62776_, blockpos);
                }
                if (blockstate.m_60734_() instanceof LiquidBlock) continue;
                BlockState blockstate1 = Block.m_49931_(blockstate, this.f_62776_, blockpos);
                this.f_62776_.m_7731_(blockpos, blockstate1, 20);
            }
            this.f_187602_[i].clear();
        }
        for (BlockPos blockpos1 : ImmutableList.copyOf(this.f_187609_.keySet())) {
            this.m_7702_(blockpos1);
        }
        this.f_187609_.clear();
        this.f_187606_.m_63341_(this);
    }

    @Nullable
    private BlockEntity m_62870_(BlockPos p_62871_, CompoundTag p_62872_) {
        BlockEntity blockentity;
        BlockState blockstate = this.m_8055_(p_62871_);
        if ("DUMMY".equals(p_62872_.m_128461_("id"))) {
            if (blockstate.m_155947_()) {
                blockentity = ((EntityBlock)blockstate.m_60734_()).m_142194_(p_62871_, blockstate);
            } else {
                blockentity = null;
                f_62771_.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)p_62871_, (Object)blockstate);
            }
        } else {
            blockentity = BlockEntity.m_155241_(p_62871_, blockstate, p_62872_);
        }
        if (blockentity != null) {
            blockentity.m_142339_(this.f_62776_);
            this.m_142170_(blockentity);
        } else {
            f_62771_.warn("Tried to load a block entity for block {} but failed at location {}", (Object)blockstate, (Object)p_62871_);
        }
        return blockentity;
    }

    public void m_187985_(long p_187986_) {
        this.f_62784_.m_193171_(p_187986_);
        this.f_187943_.m_193171_(p_187986_);
    }

    public void m_187958_(ServerLevel p_187959_) {
        p_187959_.m_183326_().m_193231_(this.f_187604_, this.f_62784_);
        p_187959_.m_183324_().m_193231_(this.f_187604_, this.f_187943_);
    }

    public void m_187979_(ServerLevel p_187980_) {
        p_187980_.m_183326_().m_193229_(this.f_187604_);
        p_187980_.m_183324_().m_193229_(this.f_187604_);
    }

    @Override
    public ChunkStatus m_6415_() {
        return ChunkStatus.f_62326_;
    }

    public ChunkHolder.FullChunkStatus m_6708_() {
        return this.f_62790_ == null ? ChunkHolder.FullChunkStatus.BORDER : this.f_62790_.get();
    }

    public void m_62879_(Supplier<ChunkHolder.FullChunkStatus> p_62880_) {
        this.f_62790_ = p_62880_;
    }

    public void m_187957_() {
        this.f_187610_.values().forEach(BlockEntity::onChunkUnloaded);
        this.f_187610_.values().forEach(BlockEntity::m_7651_);
        this.f_187610_.clear();
        this.f_156362_.values().forEach(p_187966_ -> p_187966_.m_156449_(f_156361_));
        this.f_156362_.clear();
    }

    public void m_156369_() {
        this.f_62776_.addFreshBlockEntities(this.f_187610_.values());
        this.f_187610_.values().forEach(p_187988_ -> {
            this.m_156404_(p_187988_);
            this.m_156406_(p_187988_);
        });
    }

    private <T extends BlockEntity> void m_156404_(T p_156405_) {
        GameEventListener gameeventlistener;
        Block block;
        if (!this.f_62776_.f_46443_ && (block = p_156405_.m_58900_().m_60734_()) instanceof EntityBlock && (gameeventlistener = ((EntityBlock)block).m_142226_(this.f_62776_, p_156405_)) != null) {
            GameEventDispatcher gameeventdispatcher = this.m_142336_(SectionPos.m_123171_((int)p_156405_.m_58899_().m_123342_()));
            gameeventdispatcher.m_142501_(gameeventlistener);
        }
    }

    private <T extends BlockEntity> void m_156406_(T p_156407_) {
        BlockState blockstate = p_156407_.m_58900_();
        BlockEntityTicker<?> blockentityticker = blockstate.m_155944_(this.f_62776_, p_156407_.m_58903_());
        if (blockentityticker == null) {
            this.m_156412_(p_156407_.m_58899_());
        } else {
            this.f_156362_.compute(p_156407_.m_58899_(), (p_187963_, p_187964_) -> {
                TickingBlockEntity tickingblockentity = this.m_156375_(p_156407_, blockentityticker);
                if (p_187964_ != null) {
                    p_187964_.m_156449_(tickingblockentity);
                    return p_187964_;
                }
                if (this.m_156370_()) {
                    RebindableTickingBlockEntityWrapper levelchunk$rebindabletickingblockentitywrapper = new RebindableTickingBlockEntityWrapper(tickingblockentity);
                    this.f_62776_.m_151525_(levelchunk$rebindabletickingblockentitywrapper);
                    return levelchunk$rebindabletickingblockentitywrapper;
                }
                return null;
            });
        }
    }

    private <T extends BlockEntity> TickingBlockEntity m_156375_(T p_156376_, BlockEntityTicker<T> p_156377_) {
        return new BoundTickingBlockEntity(this, p_156376_, p_156377_);
    }

    public boolean m_196863_() {
        return this.f_196848_;
    }

    public void m_196864_(boolean p_196865_) {
        this.f_196848_ = p_196865_;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @org.jetbrains.annotations.Nullable Direction side) {
        return this.capProvider.getCapability(cap, side);
    }

    public boolean areCapsCompatible(CapabilityProvider<LevelChunk> other) {
        return this.capProvider.areCapsCompatible(other);
    }

    public boolean areCapsCompatible(@org.jetbrains.annotations.Nullable CapabilityDispatcher other) {
        return this.capProvider.areCapsCompatible(other);
    }

    public void invalidateCaps() {
        this.capProvider.invalidateCaps();
    }

    public void reviveCaps() {
        this.capProvider.reviveCaps();
    }

    @Deprecated
    @Nullable
    public final CompoundTag writeCapsToNBT() {
        return this.capProvider.serializeInternal();
    }

    @Deprecated
    public final void readCapsFromNBT(CompoundTag tag) {
        this.capProvider.deserializeInternal(tag);
    }

    @Override
    public Level getWorldForge() {
        return this.m_62953_();
    }

    @FunctionalInterface
    public static interface PostLoadProcessor {
        public void m_196866_(LevelChunk var1);
    }

    public static final class EntityCreationType
    extends Enum<EntityCreationType> {
        public static final /* enum */ EntityCreationType IMMEDIATE = new EntityCreationType();
        public static final /* enum */ EntityCreationType QUEUED = new EntityCreationType();
        public static final /* enum */ EntityCreationType CHECK = new EntityCreationType();
        private static final /* synthetic */ EntityCreationType[] $VALUES;

        public static EntityCreationType[] values() {
            return (EntityCreationType[])$VALUES.clone();
        }

        public static EntityCreationType valueOf(String p_62965_) {
            return Enum.valueOf(EntityCreationType.class, p_62965_);
        }

        private static /* synthetic */ EntityCreationType[] m_156442_() {
            return new EntityCreationType[]{IMMEDIATE, QUEUED, CHECK};
        }

        static {
            $VALUES = EntityCreationType.m_156442_();
        }
    }

    class RebindableTickingBlockEntityWrapper
    implements TickingBlockEntity {
        private TickingBlockEntity f_156444_;

        RebindableTickingBlockEntityWrapper(TickingBlockEntity p_156447_) {
            this.f_156444_ = p_156447_;
        }

        void m_156449_(TickingBlockEntity p_156450_) {
            this.f_156444_ = p_156450_;
        }

        public void m_142224_() {
            this.f_156444_.m_142224_();
        }

        public boolean m_142220_() {
            return this.f_156444_.m_142220_();
        }

        public BlockPos m_142689_() {
            return this.f_156444_.m_142689_();
        }

        public String m_142280_() {
            return this.f_156444_.m_142280_();
        }

        public String toString() {
            return this.f_156444_.toString() + " <wrapped>";
        }
    }

    static class BoundTickingBlockEntity<T extends BlockEntity>
    implements TickingBlockEntity {
        private final T f_156428_;
        private final BlockEntityTicker<T> f_156429_;
        private boolean f_156430_;
        final /* synthetic */ LevelChunk f_156427_;

        BoundTickingBlockEntity(T p_156433_, BlockEntityTicker<T> p_156434_) {
            this.f_156427_ = p_156432_;
            this.f_156428_ = p_156433_;
            this.f_156429_ = p_156434_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void m_142224_() {
            block10: {
                BlockPos blockpos;
                if (!((BlockEntity)((Object)this.f_156428_)).m_58901_() && ((BlockEntity)((Object)this.f_156428_)).m_58898_() && this.f_156427_.m_156410_(blockpos = ((BlockEntity)((Object)this.f_156428_)).m_58899_())) {
                    try {
                        ProfilerFiller profilerfiller = this.f_156427_.f_62776_.m_46473_();
                        TimeTracker.BLOCK_ENTITY_UPDATE.trackStart(this.f_156428_);
                        profilerfiller.m_6521_(this::m_142280_);
                        ((BlockEntity)((Object)this.f_156428_)).tickTimer.startTiming();
                        BlockState blockstate = this.f_156427_.m_8055_(blockpos);
                        if (((BlockEntity)((Object)this.f_156428_)).m_58903_().m_155262_(blockstate)) {
                            this.f_156429_.m_155252_(this.f_156427_.f_62776_, ((BlockEntity)((Object)this.f_156428_)).m_58899_(), blockstate, this.f_156428_);
                            this.f_156430_ = false;
                        } else if (!this.f_156430_) {
                            this.f_156430_ = true;
                            f_62771_.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::m_142280_), LogUtils.defer(this::m_142689_), blockstate});
                        }
                        profilerfiller.m_7238_();
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.m_127521_(throwable, "Ticking block entity");
                        CrashReportCategory crashreportcategory = crashreport.m_127514_("Block entity being ticked");
                        ((BlockEntity)((Object)this.f_156428_)).m_58886_(crashreportcategory);
                        if (((Boolean)ForgeConfig.SERVER.removeErroringBlockEntities.get()).booleanValue()) {
                            f_62771_.error("{}", (Object)crashreport.m_127526_());
                            ((BlockEntity)((Object)this.f_156428_)).m_7651_();
                            this.f_156427_.m_8114_(((BlockEntity)((Object)this.f_156428_)).m_58899_());
                            break block10;
                        }
                        throw new ReportedException(crashreport);
                    }
                    finally {
                        ((BlockEntity)((Object)this.f_156428_)).tickTimer.stopTiming();
                    }
                }
            }
        }

        public boolean m_142220_() {
            return ((BlockEntity)((Object)this.f_156428_)).m_58901_();
        }

        public BlockPos m_142689_() {
            return ((BlockEntity)((Object)this.f_156428_)).m_58899_();
        }

        public String m_142280_() {
            return BlockEntityType.m_58954_(((BlockEntity)((Object)this.f_156428_)).m_58903_()).toString();
        }

        public String toString() {
            return "Level ticker for " + this.m_142280_() + "@" + this.m_142689_();
        }
    }
}

